function s = k2s(k,TTM)
%==========================================================================================
%The function converts the k for a Weibull distribution to an
%approximated value of sigma of a log-normal distribution by matching the
%variances of the two log-distributions (normal vs Gumbel)
%INPUT:
%   k: k for a Weibull distribution
%   TTM: time to maturity of the options (in years)
%
%OUTPUT:
%   s: sigma of a lognormal distribution
%==========================================================================================
% This ver: 2023/05/24
% Authors: Yifan Li (yifan.li@manchester.ac.uk)
%          Ingmar Nolte (i.nolte@lancaster.ac.uk)
%          Manh Pham (m.c.pham@lancaster.ac.uk)
% Reference: Li, Y., Nolte, I., and Pham, M. C. (2023). Parametric Risk-Neutral 
%          Density Estimation via Finite Lognormal-Weibull Mixtures
%========================================================================================== 


s = k*pi/sqrt(6)/TTM;
end

